# Sustainable development goals and the strategic role of business: A systematic literature review

Chiara Mio1 | Silvia Panfilo1 $\textcircled{1}$ | Benedetta Blundo2

1 Department of Management, Ca' Foscari University of Venice, Venice, Italy 2 Graduate in Business Administration and Finance, Ca' Foscari University of Venice, Venice, Italy

# Correspondence

Panfilo Silvia, Department of Management, Ca' Foscari University of Venice, San Giobbe Cannaregio 873, 30121. Venice, Italy. Email: silvia.panfilo@unive.it

# Abstract

The United Nations' Sustainable Development Goals (SDGs) are an urgent call for action by all countries that provide a global framework for achieving global development while balancing social, economic, and environmental sustainability. SDGs are addressed to all actors in society, but both academia and professional recognize the particular importance of businesses. However, research is still needed to understand the role of companies as sustainable development agents. Relying on Scopus database consultation, the current research adopts an interdisciplinary systematic literature review to investigate, analyze, and present state-of-the-art academic literature on the role of businesses in tackling SDGs. The final sample comprises 101 papers published between 2015 and 2020. It provides evidence that the main topics discussed by scholars are related to aspects of strategy execution. Recognizing different streams that are currently unexplored—despite strictly related to strategic business activities and to the sustainable development as a whole—the study provides many insights for future research on business and SDGs.

# K E Y W O R D S

Agenda 2030, business, private sector, SDGs, sustainable development goals, systematic literature review

# 1 | INTRODUCTION

The definition and applicability of “sustainable development” have caused years of heated debate in the academic world (Hopwood, Mellor, & O'Brien, 2005). For this reason, the United Nations' (UN) Sustainable Development Goals (SDGs) have been welcomed, as they provide a global framework for every actor pursuing the balance between social, economic, and environmental sustainability (Sachs, 2012). The SDGs were first introduced in 2015 to provide a more sustainable future for all and trace the sustainability path until 2030. The SDGs are an interconnected set of measurable goals designed to address interrelated challenges and achieve global sustainable development. They are addressed to all actors in society: governments, civil society, nonprofit organizations, and the private sector. Given its resources and scope of activity, the private sector1 — especially large multinational firms—is considered a key factor in the achievement of SDGs (UN, 2015).

Berrone et al. (2019) have argued that the private sector has a unique role to play in the pursuit of SDGs, given the specific capacities it may contribute to this cause: “financing, sector-specific expertise and knowledge, managerial and enforcement capacity, and a higher willingness to take risks” (p. 16). Further, Stewart et al. (2018) have highlighted that Goal 12—ensure sustainable consumption and production patterns—“puts renewed attention to the role of business in sustainable development” (p. 1751). Although the business contribution to achieving the SDGs is unquestionable (Garcia-Sanchez, Rodriguez-Ariza, Aibar-Guzmàn, & Aibar-Guzmàn, 2020; Sullivan,

Thomas, & Rosano, 2018), research is still needed to understand the role of organizations in tackling sustainable development based on the SDG framework and their role as sustainable development agents (Haffar & Searcy, 2018; Wicki & Hansen, 2019). The SDG framework allows companies to follow a global system of (nonquantitative) targets, thus requiring research to determine which business practices align with an SDG-based approach to sustainable development (Haffar & Searcy, 2018).

Professionals have highlighted the lack of knowledge about the role of business in addressing SDGs and its relevance for sustainable development. For instance, the “SDG Challenge Report” released by PwC in 2019 claims, “While there is a general acknowledgement of the importance of the goals, there is still not enough understanding of what [companies'] concrete action should be or is taking place” (PWC, 2019, p.6). Further, the Business and Sustainable Development Commission suggests incorporating SDGs into business strategy, rethinking entire organizations from this perspective, and collaborating with peers to move towards SDG achievement faster (WBCSD, 2017). Thus, in line with Noci and Verganti's (1999) suggestion that firms can use the concept of sustainability as an orientation point in the context of strategic change (Wicki & Hansen, 2019, p.982), both academia and practice call for businesses to take up the opportunity and challenge of becoming SDG agents. Through an interdisciplinary systematic literature review, the current study investigates, analyzes, and presents the state-of-the-art academic literature on the role of businesses in sustainable development, and specifically in tackling SDGs.

The results of the review make clear the key role played by the discipline of business management and accounting, and in particular by the scholars publishing in the field of strategy and management. The main topics discussed by scholars are related to aspects of strategy execution, such as SDG implementation, company, and industry roles in achieving SDGs; entrepreneurship to pursue SDGs; and the relation between corporate social responsibility (CSR) and SDGs. The review thus contributes to the identification of research insights and gaps deriving from the current academic debate.

This paper is structured as follows: First, an overview of the sustainable development framework is provided, leading to the identification of the research gap, the definition of the research question, and the design used to explore the topic. Second, the results of the analysis are illustrated and commented upon. Finally, insights for future research are discussed and conclusions provided.

# 2 | TOWARDS THE SUSTAINABLEDEVELOPMENT: FROM THE MILLENNIUMDEVELOPMENT GOALS TO THESUSTAINABLE DEVELOPMENT GOALS

The Millennium Development Goals (MDGs) were issued in 2001 (see Table 1), just after the UN Millennium Declaration was signed in 2000. Leaders of 189 countries committed to achieving a set of eight measurable goals that ranged from halving extreme poverty and hunger to promoting gender equality and reducing child mortality by 2015 (SDG Fund, 2019). They “were revolutionary in providing a common language” (SDG Fund, 2019) to achieve sustainable development through a global mobilization, despite not being formally adopted by UN member states (UN, 2015).

T A B L E 1 The Millennium Development Goals (MDGs)   

<html><body><table><tr><td>Goal 1</td><td>Eradicate extreme poverty and hunger</td></tr><tr><td>Goal 2</td><td>Achieve universal primary education</td></tr><tr><td>Goal 3</td><td>Promote gender equality and empower women</td></tr><tr><td>Goal 4</td><td> Reduce child mortality</td></tr><tr><td>Goal5</td><td>Improve maternal health</td></tr><tr><td>Goal 6</td><td>Combating HIV/AIDs, malaria, and other diseases</td></tr><tr><td>Goal 7</td><td>Ensure environmental sustainabiity</td></tr><tr><td>Goal 8</td><td>Develop global partnership for development</td></tr></table></body></html>

Source: https://www.sdgfund.org/mdgs-sdgs.

Following the Rio $^ { + 2 0 }$ Summit and relying on MDGs' results, the UN enhanced the global sustainable development initiative and introduced the SDGs in September 2015 (see Table 2). The SDGs are at the heart of the 2030 Agenda,2 a “plan of action” to globally pursue sustainable development—balancing its people, planet, and prosperity components—by the target year 2030 (UN, 2014). During this time, all sustainable development actions are meant to be accomplished within the overarching framework provided by the SDGs and the Agenda (UN, 2015).

Resolution A/RES/70/1, “Transforming our World: the 2030 Agenda for Sustainable Development” (UN, 2015), formally introduced the Agenda and the set of 17 integrated and indivisible goals (i.e., action in one area will affect outcomes in another; the goals are characterized by an interlinked nature necessary to answer interrelated challenges and to achieve the 2030 target). The resolution defined each goal and detailed it through nonquantitative targets (169 in total).

Academic opinions of the SDGs vary. Some researchers have been critical of the SDGs, asking for more incentives for business (e.g., Sachs, 2012), highlighting some shortcomings, and encouraging design improvements (Hák, Janoušková, & Moldan, 2016, 2018; Spangenberg, 2017). Others have highlighted the comprehensiveness and ambition of the initiative (Biermann, Kanie, & Kim, 2017) considering the SDG targets to be multiple and well informed (Scott & Lucci, 2015). Overall, the international reaction has been positive (Spangenberg, 2017). Positive assessments refer to both individual targets and to the overall SDG content, although some authors have noted that the expected benefits arise only if the SDGs as a whole are taken into account (e.g., Orme, Cuthbert, Sindico, Gibson, & Bostic, 2015; Waage et al., 2015). Accordingly, the need for and identification of the right agent(s) is a sine qua non condition of the sustainable development initiative (Bulkeley $\&$ Newell, 2015). In particular, the 2030 Agenda attributed to business a key role in sustainable development, from providing means to politically determined objectives to being an agent playing a prominent role in defining objectives and strategies (Scheyvens, Banks, & Hughes, 2016). Despite that, the Agenda invites business to engage voluntarily.

T A B L E 2 The Sustainable Development Goals (SDGs)   

<html><body><table><tr><td>Goal 1 No Poverty</td><td></td></tr><tr><td> Goal 2</td><td> Zero Hunger</td></tr><tr><td>Goal 3</td><td>Good Health and Well-being</td></tr><tr><td>Goal 4</td><td> Quality Education</td></tr><tr><td>Goal 5</td><td>Gender Equality</td></tr><tr><td>Goal 6</td><td>Clean Water and Sanitation</td></tr><tr><td>Goal7</td><td>Affordable and Clean Energy</td></tr><tr><td>Goal 8</td><td>Decent Work and Economic Growth</td></tr><tr><td>Goal9</td><td> Industry, Innovation and Infrastructure</td></tr><tr><td>Goal 10</td><td> Reduced Inequality</td></tr><tr><td>Goal 11</td><td>Sustainable Cities and Communities</td></tr><tr><td> Goal 12</td><td>Responsible Consumption and Production</td></tr><tr><td>Goal 13</td><td>Climate Action</td></tr><tr><td>Goal 14</td><td> Life Below Water</td></tr><tr><td>Goal 15</td><td>Life on Land</td></tr><tr><td>Goal 16</td><td> Peace and Justice Strong Institutions</td></tr><tr><td>Goal 17</td><td>Partnerships to achieve the Goal</td></tr></table></body></html>

Source: https://www.un.org/development/desa/disabilities/envision2030. html.

Business's contributions to achieving the SDGs have been already recognized in prior literature (Garcia-Sanchez et al., 2020; Haffar $\&$ Searcy, 2018; Sullivan et al., 2018; Wicki & Hansen, 2019). Although the importance of organizations of every size and in every industry to the goals' achievement is acknowledged (UN, 2015), Sachs (2012) has argued that multinational corporations provide “worldwide reach, cutting-edge technologies, and massive capacity to reach large-scale solutions, which are all essential to success” in sustainable development. Furthermore, Szennay, Szigeti, Kovács, and Szabó (2019) have added that the size of these actors' operations leads them to “have a significant impact on the whole ecosystem of the planet” (p. 5).

Although much has been written on the role and impact of large international corporations on sustainable development, a variety of other business actors are central to dealing with SDGs (Kolk, Kourula, & Pisani, 2017). However, “literature specifically linking the private sector to the SDGs is sparse” (Witte & Dyliard, 2017, p. 2). Thus, the overall role ascribed to business is still unclear (Spangenberg, 2017), and further research is needed to explore that role in working towards the SDGs (Schönherr, Findler, & Martinuzzi, 2017).

In addition, scholars are called to be brave and reach out to other (sub)disciplines (Kolk et al., 2017). Indeed, because businesses have vast opportunities for helping achieve the SDGs, research is needed to understand, accelerate, and materialize these opportunities (van Zanten & van Tulder, 2018). Further, a coherent approach to studying how corporations may advance sustainable development is required to consider all the—sometimes contradictory—aspects of firms' engagement with related goals (Kolk et al., 2017).

To this end, a few literature reviews have been already published on the subject of sustainable development. For instance, Wu, Guo, Huang, Liu, and Xiang (2018) have written a panoramic review study of sustainable development in terms of its environmental, social, and economic dimensions, and Moomen, Bertolotto, Lacroix, and Jensen (2019) have performed a literature review on three decades of sustainable development in the mining sector (i.e., 1990 to 2019). Sullivan et al. (2018) have used a scoping study methodology, which combines a literature review with quantitative analysis, to research and identify the conceptual crossovers between industrial ecology and strategic management in the literature from 1945 to 2015, and how these are relevant to the potential achievement of SDGs by firms.

Our study differs in scope from prior reviews. First, relying on Scopus database consultation, our research adopts an interdisciplinary systematic review of papers published since the SDGs' definition, (i.e., between 2015 and 2020). Second, it does not focus solely on a specific industry, business size, or literature stream, instead aiming at investigating the broader role of the private sector in relation to SDGs. Thus, the current study undertakes a systematic interdisciplinary review of the literature developed after the global SDG framework, attempting to answer to the research question: What is the role of businesses in tackling the Sustainable Development Goals?

# 3 | RESEARCH DESIGN

To address the research question, the authors explore the scope of existing literature and perform a systematic literature review. According to many studies (Alvarez Jaramillo, Zartha Sossa, & Orozco! Mendoza, 2019; Delbufalo, 2012; Lettieri, Masella, & Radaelli, 2009; Littell, Corcoran, & Pillai, 2008; Sivarajah, Kamal, Irani, & Weerakkody, 2017; Tranfield, Denyer, & Smart, 2003; Webster & Watson, 2002), a systematic literature review is an organized, transparent, and replicable research methodology for the analysis of the extant literature. There are several reasons for conducting a systematic literature review, such as to determine gaps within the extant research and propose areas for further research activities; to recommend a frame of reference; and to identify current research trajectories and potential research themes (Sivarajah et al., 2017, p. 267). Thus, our review provides an interdisciplinary and an international overview of the current academic debate on business and SDGs.

The implemented methodological phases rely on Tranfield et al. (2003) and Sivarajah et al. (2017). The first phase is “planning the review process”—that is, defining the research aim and objective (see Sections 1 and 2) and developing the review protocol. The second phase is “conducting the review process”, in other words, identifying, selecting, evaluating, and synthesizing the pertinent research studies. The third phase is “reporting and dissemination of the overall research results”—that is, descriptive reporting of results and thematic reporting of journal articles.

To develop the review protocol, the authors relied on Alvarez! Jaramillo et al. (2019) and Sivarajah et al. (2017). Specifically, for articles to be suitable for this study, the following conditions must have applied:

a. The Scopus database was identified as the source for a reliable list of studies on the topic of interest;   
b. to investigate the whole debate in academia, all published journal articles (not just peer-reviewed ones) were considered, but “to enhance quality control[,] other document/source types such as conferences, trade publications, books series, books or book chapters, and editorials were omitted” (Sivarajah et al., 2017 p. 267);   
c. to enhance consistency, the search was limited to studies published in journals in a 5-year timeframe from 2015 (when the SDGs were introduced) to $2 0 2 0 ^ { 3 }$ ;   
d. given the interdisciplinary scope of the study, the search included articles belonging to any academic discipline (as classified by the Scopus database) discussing SDGs and business that were written in English;   
e. to ensure the selected articles' suitability, keywords related to SDGs and business and their synonyms were considered.4 Specifically, all works that had a word directly related to the SDGs in their titles (i.e., SDG, Sustainable Development Goal, Global Agenda, and 2030 Agenda or Sustainable Development Agenda) or among their keywords (i.e., SDG or Sustainable Development Goal), and all works whose abstracts included words related to business (i.e., organization, firm, corporat\*, company, business, enterprise, and private sector) were examined;   
f. not only empirical (i.e., case studies, results, and analyses) but also conceptual articles were selected; and   
g. final substantive suitability “was confirmed by reading the whole article for essential research perspective and satisfactory empirical data. The latter process forced an alignment between the selected articles and the research review objectives” (Sivarajah et al., 2017 p. 267).

In Phase 2, the authors relied on Delbufalo (2012) according to whom there are different stages of the database searching process. First, keywords were entered into the Scopus database following Conditions b, c, and d. This step resulted in 16,034 publications being returned. Then, title, abstract, and thorough article analyses were conducted on the collected articles based on Conditions e and f. This provided a sample of 506 interdisciplinary studies in the Scopus database as of November 29, 2019. At the end of this process, these papers were considered for further investigation. This selection was scanned for both conceptual and empirical studies using the criteria indicated in Conditions e and g. The scan led to the final sample of 101 documents. In order to respond to the research question, the authors performed a manual content analysis to develop a data set and listed their findings on a spreadsheet.

In Phase 3, the overall results of the descriptive investigation were reported. The following information was included: author(s); publication year; article title; journal title, volume, and issue; geographical focus of the study according to three criteria (journal's location, authors' affiliation, and context investigated by each study); ABS journal ranking; article's number of citations; and article's academic discipline and field (retrieved from Scimago). To obtain deeper knowledge of the academic debate dealing with the SDGs and the business, the authors also collected the following information about each article: the main topic addressed; the theoretical framework; the methodology implemented (qualitative, quantitative, or mixed); in the case of quantitative methodology, the typology of data used (primary or secondary); the specific methodology applied (e.g., case study, interview, and statistical analysis); and whether the article analyzed a specific industry. The authors also accounted for the number of SDGs addressed in each work and the identification of specific SDGs addressed.

# 4 | FINDINGS

First, an overview of the role of business in relation to SDGs within various academic disciplines is presented, along with descriptive statistics for the full sample and the subsample of Association of Business Schools' Academic Journal Guide 2018 (ABS)5 ranked articles (Section 4.1). Second, the role of business in relation to SDGs, as emerging from the main topics dealt by prior literature (Section 4.2), and a deeper investigation of them deriving from the ABS-ranked papers are described (Sections 4.2.1–4.2.7).

# 4.1 | The role of business for SDGs within various academic disciplines

Table 3 (a) exhibits information on the number of articles by academic discipline (as provided by Scimago) and year. At first glance, it appears that the topic of business and SGDs is not uniformly dealt with in academia. Despite that, total data show that interest in the topic has increased significantly over the years, more than doubling between 2018 and 2019 (from 22 to 57 published papers).

<html><body><table><tr><td> Year</td><td>Agricultural and Biological Sciences</td><td>Arts and Humanities</td><td>Business Management and Accounting</td><td>Chemical engineering</td><td>Computer Science</td><td>Earth and Planetary Sciences</td><td>Economics, Econometrics and Finance</td><td> Energy</td><td> Engineering</td><td>Science</td><td>Environmental</td><td>Social Science</td><td> Total</td></tr><tr><td>2015</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td>1</td><td></td><td></td><td></td><td></td><td>1</td></tr><tr><td>2016</td><td></td><td></td><td></td><td></td><td></td><td></td><td>1</td><td>2</td><td></td><td></td><td></td><td></td><td>3</td></tr><tr><td>2017</td><td>1</td><td></td><td>8</td><td></td><td></td><td>1</td><td></td><td></td><td>3</td><td>1</td><td></td><td></td><td>14</td></tr><tr><td>20181</td><td></td><td></td><td>12</td><td>2</td><td></td><td></td><td>1</td><td></td><td>3 1</td><td></td><td></td><td>2</td><td>22</td></tr><tr><td>20192</td><td></td><td>1</td><td>29</td><td></td><td>2</td><td>3</td><td>4</td><td>11</td><td></td><td>3</td><td></td><td>2</td><td>57</td></tr><tr><td>2020</td><td></td><td></td><td>4</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td>4</td></tr><tr><td>Total4</td><td></td><td>1</td><td>53</td><td>2</td><td>2</td><td>4</td><td>6</td><td>20</td><td>1</td><td>4</td><td></td><td>4</td><td>101</td></tr><tr><td></td><td>b. Main academic discipline andrelativefield byyear</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Year</td><td colspan="3"> Academic discipline</td><td colspan="3">Main academic field ofthe studies</td><td colspan="2">#papers</td><td> total # of paper of the academic discipline</td><td></td><td></td><td>Total # of papers by year</td><td></td></tr><tr><td>2015</td><td colspan="3">Energy</td><td> Sustainabiity</td><td></td><td>1</td><td>1</td><td></td><td></td><td></td><td>1</td><td></td><td></td></tr><tr><td>2016</td><td colspan="2">Energy</td><td> Sustainabilty</td><td></td><td></td><td>2</td><td>2</td><td></td><td></td><td></td><td>3</td><td></td><td></td></tr><tr><td>2017</td><td colspan="2">Business Management and Accounting</td><td></td><td>Business,ManagementandAccounting</td><td></td><td>5</td><td>8</td><td></td><td></td><td></td><td>14</td><td></td><td></td></tr><tr><td>2018</td><td colspan="2">Business Management and Accounting</td><td></td><td> Strategy and Management</td><td></td><td>11</td><td>12</td><td></td><td></td><td></td><td>22</td><td></td><td></td></tr><tr><td>2019</td><td colspan="2">Business anagement and Accounting</td><td></td><td>Strategy and Management</td><td></td><td>14</td><td>29</td><td></td><td></td><td></td><td>57</td><td></td><td></td></tr><tr><td>2020</td><td colspan="2">Business Management and Accounting</td><td></td><td> Strategy and Management</td><td></td><td>4</td><td>4</td><td></td><td></td><td></td><td>4</td><td></td><td></td></tr></table></body></html>

T A B L E 4 ABS journals ranking and main academic discipline   

<html><body><table><tr><td> Ranking ABS</td><td> # papers</td><td> Main academic discipline (# of papers)</td><td>%</td></tr><tr><td>3</td><td>6</td><td>Business Management and Accounting (4/6)</td><td>66.67%</td></tr><tr><td>2</td><td>29</td><td>Business Management and Accounting (24/29)</td><td>82.76%</td></tr><tr><td>1</td><td>12</td><td>Business Management and Accounting (11/12)</td><td>91.67%</td></tr><tr><td> Not ranked</td><td>54</td><td>Energy (20/54)</td><td>37.04%</td></tr><tr><td>Total</td><td>101</td><td></td><td></td></tr></table></body></html>

Relying on the main academic discipline and relative field classification by Scimago, the authors elaborated Table 3 (b). Evidence shows Energy is the academic discipline that first introduced the debate in academia in 2015, discussing the role of business in relation to the SDGs largely in terms of “Sustainability.” Since 2017, however, Business Management and Accounting has seen the most debate about it, first in generic terms and then with increasing focus on the field of “Strategy and Management,” which was the only field in which the issue was being investigated at the beginning of 2020.

Overall, the investigation of the studies according to ABS journal rankings and main academic discipline revealed that papers on the role of business for SDGs are mostly published in low-ranked journals dealing with Business Management and Accounting. Just 6 of 101 published papers have appeared in a 3-ranked ABS journal; 29 in 2-ranked journals; and, finally, 12 in 1-ranked journals. Further, Table 4 shows that the majority of the published papers on the SDGs $( 5 4 ^ { 6 }$ out of 101) have appeared in non-ABS-ranked journals belonging mainly to the academic discipline of Energy. For this reason, and given the interdisciplinary scope of the study, we decided first to investigate results considering all academic disciplines and including unranked articles, and then excluding the latter to verify potential differences in dealing with the topic.

The geographical location of the full sample was established according to three criteria: by journal headquarter location (Table 5, a), by first author's affiliation (Table 5, b), and by main context analyzed within the article (Table 5, c). The results in Table 5 (a) show Europe is where most of the journals publishing on the topic are established. Eighty of 101 papers included in this study were published in European journals, and 19 were published in US journals. African and Asian journals published just one paper each. Journals in Oceania have not published any related research. Table 5 (b) distinguishes the studies' geographical location according to the first author's affiliation. European authors represent the majority (55) of the academics interested in the role of business in achieving the SDGs, independent of the academic discipline they belong to. At distance, they are followed by Americans (17) and authors from Oceania (16), then Asian (11) and African (4) authors. Finally, Table 5 (c) shows that the geographical context analyzed in the articles are, in order, Europe (17), Asia (10), America (7), Africa (5), and Oceania (2).

Results regarding the geographical location of studies published in ABS-ranked journals are provided in Table 6 (a–c). Compared with the full sample, results show that in terms of journal headquarter (Table 6, a) just European and American ranked journals publish articles on such a topic. There is an increasing interest in the topic in Europe in particular, as demonstrated by the trend over years. American (all US-based) journals show a limited but constant interest in it over time. Table 6 (b) shows that first authors are mainly affiliated with European universities (23), but unlike in the full sample, there are more first authors from Oceania (11) than from America (10). They are then followed by Asian (2) and African first authors (1). Finally, Table 6 (c) demonstrates that both European and American contexts are equally investigated in ranked journals (7 articles each). Asia and Oceania follow (3 each), and Africa is the least-investigated context (2). The remaining articles investigate more than one continent or no one in particular.

Results also show there are many industries that are investigated more than others in studies about businesses and SDGs. Specifically, the full sample presents the mining industry as the most investigated, followed in equal degree by the banking, fishing, and tourism industries (Table 7, a). Similarly, the subsample composed of just by ABSranked journals is still mainly focused on the investigation of the mining industry, followed in equal degree by fishing, manufacturing, and tourism industries (Table 7, b).

To compare academic research with evidence from corporate practice (i.e., PWC report, 2019), we also investigated how many (Figure 1a,b) and which (Figure 2a,b) SDGs were mentioned in the articles. Figure 1a shows that $78 \%$ of papers in the full sample deal with all the 17 SDGs. Another $6 \%$ discuss one single SDG, $4 \%$ mention seven SDGs, and $3 \%$ mention three SDGs. Finally, two and eight SDGs are discussed by the $2 \%$ of the full sample. Looking in detail at the specific SDGs mentioned, Figure 2a reveals the three most discussed goals are Goal 9 (Industry, Innovation, Infrastructure), with $5 7 \%$ of articles in the full sample mentioning specific goals; Goal 3 (Good Health and Well-Being) by $4 3 \%$ ; and at Goal 6 (Clean Water and Sanitation), Goal 12 (Responsible Consumption and Production), and Goal 13 (Climate Action), each mentioned in $3 6 \%$ of the studies.

Figures 1b and 2b focus on the subsample of ABS-ranked articles. The former indicates results are quite in line with the overall sample. Articles in ranked journals mainly mention all the 17 SDGs $2 5 \%$ of the subsample). The only difference from the full sample is that no one paper mentions eight goals. The latter figure reveals that in ABS journals, mentions of specific SDGs are distributed at three levels. The first level deals only with Goal 9 (Industry, Innovation, and Infrastructure). Studies focused solely on this SDG represent the $3 8 \%$ of the articles mentioning specific goals. The second is represented by goals mentioned in $2 5 \%$ of the cases: Goals 3 (Good Health and WellBeing), 5 (Gender Equality), 7 (Affordable and Clean Energy), 8 (Decent Work and Economic Growth), 13 (Climate Action), and 14 (Life below Water). Finally, at the third level, goals are mentioned in $1 3 \%$ of the cases: Goals 2 (Zero Hunger), 6 (Clean Water and Sanitation), 10 (Reduced Inequality), 12 (Responsible Consumption and Production), and 17 (Partnerships to Achieve the Goal). Unlike those in the overall sample, ABS-ranked papers do not deal at all with SDGs 1 (No Poverty), 4 (Quality Education), 15 (Life on Land), or 16 (Peace and Justice Strong Institutions).

T A B L E 5 Geographical location   

<html><body><table><tr><td colspan="6">a. Geographical location by journal headquarter</td></tr><tr><td colspan="6"> Journal geographical location</td></tr><tr><td></td><td> Africa</td><td> America</td><td>Asia</td><td>Europe</td><td> Oceania</td></tr><tr><td colspan="6">2015</td></tr><tr><td>2016</td><td></td><td>2</td><td></td><td>1 1</td><td></td></tr><tr><td>2017</td><td></td><td>6</td><td>1</td><td>7</td><td></td></tr><tr><td>2018</td><td></td><td>4</td><td></td><td>18</td><td></td></tr><tr><td>2019</td><td>1</td><td>7</td><td></td><td>49</td><td></td></tr><tr><td>2020</td><td></td><td></td><td></td><td>4</td><td></td></tr><tr><td>Total 1</td><td></td><td>19</td><td>1</td><td>80</td><td>0</td></tr><tr><td colspan="6">b. Geographicallocationbyfirstauthors&#x27;affiliation</td></tr><tr><td></td><td></td><td>First authorgeographicalaffiliation</td><td></td><td></td><td></td></tr><tr><td colspan="6"> Africa</td></tr><tr><td>2015</td><td></td><td> America</td><td> Asia</td><td>Europe 1</td><td> Oceania</td></tr><tr><td>2016</td><td></td><td>2</td><td></td><td>1</td><td></td></tr><tr><td>2017</td><td></td><td>2</td><td>3</td><td>5</td><td>4</td></tr><tr><td>2018</td><td></td><td>1</td><td>3</td><td>15</td><td>3</td></tr><tr><td>2019</td><td>3</td><td>11</td><td>5</td><td>31</td><td>7</td></tr><tr><td>2020</td><td>1</td><td>1</td><td></td><td>2</td><td></td></tr><tr><td>Total</td><td>4</td><td>17</td><td>11</td><td>55</td><td>16</td></tr><tr><td colspan="6">c. Geographical location by context analyzed</td></tr><tr><td colspan="6"> Article geographical location</td></tr><tr><td colspan="6">Only Africa 5</td></tr><tr><td colspan="6">Only America 7</td></tr><tr><td colspan="6">Only Asia 10</td></tr><tr><td colspan="2">Only Europe 17</td><td colspan="4"></td></tr><tr><td colspan="2">Only Oceania 2</td><td colspan="4"></td></tr><tr><td colspan="6"></td></tr></table></body></html>

Table 8 (a and b) provides results on the top three papers of the sample by number of citations (as from Scopus). The former table shows that the number of citations ranges between 37 and 120 and refers to papers published in the first years since the release of the SDGs. All belong to unranked journals and to Energy academic discipline. All three mention the 17 SDGS and deal with the role of business in relation SDGs in a conceptual way. Specifically, the paper by Hajer et al. (2015) in Sustainability journal is the most cited (120 citations) and the first ever to be published. It is followed by Scheyvens et al. (2016) and Spangenberg (2017), both published in Sustainable Development journal (54 and 37 citations, respectively). When we focus on ABS-ranked journals, the number of citations shrinks, ranging between 0 and 24. In this case, the top three most cited studies on the role of business in advancing SDGs are all published in a 2-ranked journal (Journal of Cleaner Production) and belong to the Business Management and Accounting discipline and to the “Strategy and Management” field. All the top three papers adopt a qualitative methodology, and two of them mention all 17 SDGs. The most cited paper is by Xia, Olanipekun, Chen, Xie, and Liu (2018), with 24 citations; the second one is by

T A B L E 6 Geographical location   

<html><body><table><tr><td colspan="6"> a. Geographical location by journal headquarter</td></tr><tr><td></td><td colspan="5"> Journal geographical location</td></tr><tr><td></td><td> Africa</td><td> America</td><td>Asia</td><td>Europe</td><td> Oceania</td></tr><tr><td>2015</td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>2016</td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>2017</td><td></td><td>5</td><td></td><td>3</td><td></td></tr><tr><td>2018</td><td></td><td>2</td><td></td><td>7</td><td></td></tr><tr><td>2019</td><td></td><td>3</td><td></td><td>23</td><td></td></tr><tr><td>2020</td><td></td><td></td><td></td><td>4</td><td></td></tr><tr><td>Total</td><td>0</td><td>10</td><td>0</td><td>37</td><td>0</td></tr><tr><td colspan="6">b. Geographical location by first authors&#x27; affiliation</td></tr><tr><td rowspan="2"></td><td></td><td>First author geographical affiliation</td><td></td><td></td><td></td></tr><tr><td> Africa</td><td> America</td><td> Asia</td><td>Europe</td><td> Oceania</td></tr><tr><td>2015</td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>2016</td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>2017</td><td></td><td>2</td><td>1</td><td>2</td><td></td></tr><tr><td>2018</td><td></td><td></td><td></td><td>6</td><td>3</td></tr><tr><td>2019</td><td></td><td>7</td><td>1</td><td>13</td><td>3</td></tr><tr><td>2020</td><td>1</td><td>1</td><td></td><td>2</td><td>5</td></tr><tr><td>Total</td><td>1</td><td>10</td><td>2</td><td>23</td><td>11</td></tr><tr><td colspan="6"> c. Geographical location by context analyzed</td></tr><tr><td colspan="6">Article geographical location</td></tr><tr><td colspan="2"> only Africa</td><td>2</td><td></td><td></td><td></td></tr><tr><td colspan="2">only America</td><td>7</td><td></td><td></td><td></td></tr><tr><td colspan="2"> only Asia</td><td>3</td><td></td><td></td><td></td></tr><tr><td colspan="2">only Europe</td><td>7</td><td></td><td></td><td></td></tr></table></body></html>

Morioka, Bolis, Evans, and Carvalho (2017), with 22 citations; and the third is by Sullivan et al. (2018), with 16 citations.

T A B L E 7 Main industries   

<html><body><table><tr><td> a. Full sample</td></tr><tr><td>Industry # of papers</td></tr><tr><td>Mining/extractive 6</td></tr><tr><td>Fishing 2</td></tr><tr><td>Manufacturing/service 2</td></tr><tr><td>Tourism 2</td></tr><tr><td>Mining/extractive 7</td></tr><tr><td>Bank 3</td></tr><tr><td>Fishing 3</td></tr><tr><td>Tourism 3</td></tr><tr><td> b. ABS ranked articles</td></tr><tr><td>Industry # of papers</td></tr><tr><td>Mining/extractive 6</td></tr><tr><td>Fishing 2</td></tr><tr><td>Manufacturing/service 2</td></tr><tr><td>Tourism 2</td></tr><tr><td>Mining/extractive 7</td></tr><tr><td>Bank 3</td></tr><tr><td>Fishing 3</td></tr><tr><td>Tourism 3</td></tr></table></body></html>

an equal extent, topics such as capital market and SDGs, SDGs benefits, private-public partnerships (PPP) and SDGs, SDGs interactions and relevance, SDGs disclosure, and business sustainability framework in connection with SDGs (less than $5 \%$ each).

Figure 3b shows that the articles published in ABS journals deal with the link between CSR and SDGs $( 7 . 9 2 \% )$ , SDGs adoption $( 6 . 3 8 \% )$ , SDGs benefits, and capital market $4 . 2 5 \%$ each). ABS journals deal with the topics of SDGs performance metrics/tools, SDGs relevance, PPP and SDGs, business sustainability framework, and SDGs disclosure only in passing $( 2 . 1 2 \%$ of the sample each).

# 4.2 | The role of business for SDGs: Main topics

Given our focus on business's role in tackling the SDGs, we ranked the main topics dealt by the collected articles. Figure 3a,b shows the ranking according to the whole interdisciplinary sample (101 papers) and the subsample of ABS-ranked articles (47), respectively. The top four topics are the same in both samples. The most investigated area is SDG implementation $( 2 2 . 7 7 \%$ vs. $2 7 . 6 5 \%$ , respectively). The second topic of interest is the company's role in SDGs achievement or governance $1 6 . 8 3 \%$ vs. $1 7 . 0 2 \%$ ). The third top topic is the industry role in achieving SDGs ( $1 1 . 8 8 \%$ vs. $1 0 . 6 3 \%$ ) Entrepreneurship as a means of pursuing SDGs $8 . 9 1 \%$ vs. $1 0 . 6 3 \%$ is discussed.

After the fourth position, the two samples partially differ in the order. Specifically, Figure 3a shows that, after entrepreneurship, the whole academic sample then addresses SDGs performance metrics or tools $( 7 . 9 2 \% )$ ; CSR and SDGs $( 6 . 9 3 \% )$ ; SDGs adoption $( 5 . 9 4 \% )$ ; and, to

# 4.2.1 | SDGs implementation

The main topic investigating the role of business in addressing the SDGs refers to business' SDGs implementation $( 2 7 . 6 5 \%$ of the sample). Table 9 shows the studies participating in the academic debate. The papers focusing on that topic were published in journals whose ranking ranged between 1 and 3 in the period 2017–2019. With the exception of the Marine Policy journal, which belongs to the Agricultural and Biological Sciences discipline, all the journals belong to the Business Management and Accounting area. Among these, the majority of the papers (6 out of 12) are published in journals in the “Strategy and Management” field, followed by the miscellaneous “Business Management and Accounting” category (4 out of 12) and the “Tourism” field (2 out of 12).

Most of the authors (Christ & Burritt, 2019; Isaksson, 2019; Muff, Kapalka, & Dyllick, 2017; Raub & Martin-Rios, 2019;

![](images/2af859946f8722b7f9e4000e5765b8c1624d7cbbca24d6da1275f3052d942166.jpg)  
F I G U RE 1 (a) Number of Sustainable Development Goals (SDGs) mentioned in the articles (%): full sample. (b) Number of SDGs mentioned in the articles $( \% )$ : ABS subsample

Vandenbrande, 2019) deal with the topic using conceptual and interpretative methodologies, mainly by developing frameworks for SDG implementation. Avery and Hooper (2017) and Fleming, Wise, Hansen, and Sams (2017) investigate the role of business in SDGs implementation by adopting case studies. Boiral, Heras-Saizarbitoria, and Brotherton (2019) and Gössling and Michael Hall (2019) focus on businesses belonging to specific industries, extractive and tourism, respectively. Guandalini, Sun, and Zhou (2019) and Muff, Kapalka, and Dyllick (2018) assess the implementation of SDGs through strategic business tools. The studies by

Munro and Arli (2019) and Pineda-Escobar (2019) instead adopt a quantitative approach. The former rely on primary data (online questionnaire) of a company's internal stakeholders, the latter on secondary ones based on a specific country (Colombia).

![](images/a5fecb7ab6494a0852ef3f81a8eedda0507b772341e08b9877a6518341203cb8.jpg)  
F I G U R E 2 (a) Specific Sustainable Development Goals (SDGs) mentioned in the articles: full sample. (b) Specific SDGs mentioned in the articles: ABS subsample [Colour figure can be viewed at wileyonlinelibrary.com]

Finally, the papers related to SDGs implementation topic mostly discuss or mention all 17 SDGs. Just one article (Avery & Hooper, 2017) focuses on specific SDGs, mostly related to people's health and working conditions (Goals 3, Good Health and Well-Being; 5, Gender Equality; and 8, Decent Work and Economic Growth).

![](images/1e0672efab08d07118cbde6d9efbd9b85f7aa269a56a09348ae40faf62b70520.jpg)

<html><body><table><tr><td>Citations</td><td>Author(s)</td><td>Year</td><td>Title</td><td> Journal (ABS ranking)</td><td> Academic discipline</td><td>Academic category</td><td>Methodology</td><td>SDGs mentioned</td></tr><tr><td>120</td><td>Hajer et al.</td><td>2015</td><td>Beyond cockpitism: Four insights to enhance the transformativepotentialof thesustainable development goals</td><td>Sustainabity (not ranked)</td><td>Energy</td><td> Sustainability</td><td>Qualitative (conceptual)</td><td>AlI</td></tr><tr><td>54</td><td> Scheyvens et al. 2016</td><td></td><td>The Private Sector and the SDGs: The Need to Move Beyond &quot;Business as Usual&quot;</td><td>Sustainable Development (not ranked)</td><td>Energy</td><td>Energy</td><td>Qualitative (conceptual)</td><td>All</td></tr><tr><td>37</td><td> Spangenberg</td><td>2017</td><td>HotAir or Comprehensive Progress?ACritical Assessment of the SDGs</td><td>Sustainable Development (not ranked)</td><td>Energy</td><td>Energy</td><td>Qualitative (conceptual)</td><td>Al</td></tr><tr><td colspan="9">b. By number of citations: ABS ranked articles</td></tr><tr><td>Citations</td><td>Author(s)</td><td>Year Title</td><td></td><td> Journal (ABS ranking)</td><td> Academic discipline</td><td>Academic category</td><td>Methodology</td><td>SDGs mentioned</td></tr><tr><td>24</td><td> Xia et al.</td><td>2018</td><td>Conceptualisingthestateoftheart of corporate social responsibility (CSR)in the construction industry and its nexus to sustainable development</td><td>Journal of Cleaner Production (2)</td><td>Business Management and Accounting</td><td>Strategy and Management</td><td>Qualitative</td><td>All</td></tr><tr><td>22</td><td> Morioka et al.2017</td><td></td><td>Transforming sustainability challenges into competitive advantage: Multiple case studies kaleidoscope converging into sustainable businessmodels</td><td>Journal of Cleaner Production (2)</td><td>Business Management and Accounting</td><td>Strategy and Management</td><td> Qualitive</td><td>All</td></tr><tr><td>16</td><td> Sllivan et al.</td><td>2018</td><td>Using industrial ecology and strategic management concepts to pursue the Sustainable Development Goals</td><td>Journal of Cleaner Production (2)</td><td>Business Management and Accounting</td><td>Strategy and Management</td><td> Qualitative</td><td>Goals: 7,9, 12,and 13</td></tr></table></body></html>

![](images/96f3c3ed941f7eb2ffd7e2ed4c2570d51498e0ec8a414cd35ba4705aaaf67a0d.jpg)  
F I G U R E 3 (a) Topics ranking: full sample. (b) Topics ranking: only ABS ranked articles

# 4.2.2 | Company role in achieving SDGs

The second major topic discussed by academia regards the company role in achieving SDGs $( 1 7 . 0 2 \% )$ . Table 10 exhibits the studies on this topic. The papers in this subsample were published in the timespan 2017–2020 in journals ranked from 1 to 3. The majority were published in the Journal of Cleaner Production (5 out of 8 articles). Apart from the study published in the Review of International Political Economy, which belongs to the Economics, Econometrics, and Finance academic discipline, all the other studies fall under Business Management and Accounting. The company role in achieving SDGs is predominantly debated from a “Strategy and Management” perspective (6 out of 8).

Studies on the role of the company in achieving SDGs fall into two streams: Calabrese, Forte and Ghiron (2018); Pohlmann, Scavarda, Alves, and Korzenowski (2019); Sharma and Soederberg (2019); and Sullivan et al. (2018) investigate it from strategic and management perspectives. Goralski and Tan (2020); Ike, Donovan, Topple, and Masli (2019); Naciti (2019); and Topple, Donovan, Masli, and Borgert (2017), on the other hand, analyze it through a governance lens. Most of the studies adopt a qualitative approach: Calabrese et al. (2018), Pohlmann et al. (2019), and Goralski and Tan (2020) use case studies; Ike et al. (2019) and Topple et al. (2017) adopt semistructured interviews; Sharma and Soederberg (2019) present a conceptual paper; and Sullivan et al. (2018) adopt a scoping methodology to review the literature. Naciti's (2019) is the only study investigating the topic through a quantitative methodology adopting secondary data.

Most of the studies debate the full set of SDGs, with three exceptions: Goralski and Tan (2020) discuss a group of goals (2, Zero Hunger; 3, Good-Health and Well-Being; 6, Clean Water and Sanitation; 9, Industry, Innovation, and Infrastructure; 10, Reduce Inequality; 11, Sustainable Cities and Communities; and 14, Life Below Water); Sharma and Soederberg (2019) investigate a single goal (11); and Sullivan et al. (2018) find the integration of industrial ecology and business strategy is relevant for a mainly environmentally related group of goals (7, Affordable and Clean Energy; 9, Industry, Innovation, and Infrastructure; 12, Responsible Consumption and Production; and 13, Climate Action), even if the review captures all the SDGs to varying degrees.

# 4.2.3 | Entrepreneurship to pursue SDGs and the industry role in achieving SDGs

Entrepreneurship as a means of pursuing SDGs is another relevant topic discussed in academia between 2018 and 2020 $( 1 0 . 6 4 \% )$ . Table 11 (a) shows all the subsample belongs to the Business Management and Accounting discipline and deals with two main fields: “Strategy and Management” and “Business and International Management.”

Specifically, Horne, Recker, Michelfelder, Jay, and Kratzer (2020) explore the relation between entrepreneurship and SDGs through a quantitative methodology, whereas Mintrom and Thomas (2018) and Schaltegger, Beckmann, and Hockerts (2018) both published in International Journal of Entrepreneurial Venturing and focus on entrepreneurship to pursue sustainable development, the latter adopting a conceptual approach. The very recent studies by Molthan-Hill, Robinson, Hope, Dharmasasmita, and McManus (2020) and Nwagwu (2020), published in the International Journal of Management Education, instead focus on responsible management education to pursue SDGs. Molthan-Hill et al. (2020) in particular focus on specific goals: 7 (Affordable and Clean Energy), 13 (Climate Action), and 17 (Partnership to Achieve Goals). All the other papers generally deal with the full SDGs set.

<html><body><table><tr><td colspan="6"> Theoretical</td><td rowspan="2">Methodology</td><td rowspan="2">(primary/ SDGs secondary) mentio</td></tr><tr><td>Authors Year</td><td>Journal (ABS ranking) Strategy and</td><td>Title How David Cooke</td><td>Academic discipline Business Management</td><td>Academic field Strategy and</td><td>framework/ background United Nations&#x27;</td></tr><tr><td>Avery and Hooper (2017)</td><td>Leadership (1)</td><td>implemented corporate social responsibility at Konica Minolta Australia</td><td>and Accounting</td><td>Management</td><td>sustainable development goals</td><td>Qualitative</td><td>Goals: 5,an</td></tr><tr><td> Boiral et al. (2019)</td><td>Journal of Cleaner Production (2)</td><td>Corporate sustainabity and indigenous community engagement in the extractive industry</td><td>Business Management and Accounting</td><td>Strategy and Management</td><td>Corporate sustainability community engagement</td><td> Qualitative</td><td>All</td></tr><tr><td>Christ and Burrtt (2019)</td><td>Australian Journal of Management (2)</td><td>Implementation of sustainable development goals: The role for business academics</td><td>Business Management and Accounting</td><td>Business Management and Accounting</td><td>Business academics&#x27; role</td><td>Qualitative (conceptual)</td><td>Al</td></tr><tr><td>Fleming et al. (2017)</td><td> Marine Policy (2)</td><td>The sustainable development goals: A case study</td><td>Agricultural and Biological sciences</td><td> Aquatic Science</td><td>Values-Rules- Knowledge framework of decision making</td><td> Qualitative</td><td>All </td></tr><tr><td>Gossling and Michael Hall (2019)</td><td>Journal of Sustainable Tourism (3)</td><td>Sharing versus collaborative economy: how to align ICT developments and the SDGs in tourism?</td><td>Business Management and Accounting</td><td>Tourism</td><td> Sharing economy</td><td>Qualitative</td><td>All</td></tr><tr><td>Guandalini et al (2019)</td><td>Journal of Cleaner Production (2)</td><td>Assessing the implementation of Sustainable Development Goals through switching cost</td><td>Business Management and Accounting</td><td>Strategy and Management</td><td>Switching cost analysis</td><td> Qualitative</td><td>All </td></tr><tr><td>Isaksson (2019)</td><td>Total Quality Management and Business Excellence (2)</td><td>Excellence for sustainability- maintaining the license to operate</td><td>Business Management and Accounting</td><td>Business Management and Accounting</td><td>Planetary boundaries, UN SDGs, Natural step framework</td><td>Qualitative (conceptual)</td><td>Al</td></tr><tr><td> Muff et al. (2017)</td><td>International Journal of Management Education (1)</td><td>The Gap Frame - Translating the SDGs into relevant national grand challenges for strategic business opportunities</td><td>Business Management and Accounting</td><td>Strategy and Management</td><td>Corporate Sustainability Assessment</td><td>Qualitative (conceptual)</td><td>All</td></tr></table></body></html>

<html><body><table><tr><td colspan="6"> Journal (ABS</td><td rowspan="2">Theoretical framework/ background</td><td rowspan="2">Methodology</td><td rowspan="2">(primary/ secondary)</td><td rowspan="2">SDGs mentionee</td></tr><tr><td> Authors</td><td>Year</td><td>ranking) Title International Journal</td><td>Moving the world</td><td>Academic discipline Business Management</td><td>Academic field Strategy and Corporate</td></tr><tr><td> Munro and Arli (2019)</td><td></td><td>of Management Education (1) International Journal</td><td>into a safe space- the GAPFRAME methodology Corporate sustainable</td><td> and Accounting</td><td>Management</td><td>Sustainability Assessment Political CSR, Social</td><td> Quantitative</td><td>Primary</td><td>All</td></tr><tr><td></td><td></td><td>of Nonprofit and Voluntary Sector Marketing (1)</td><td>actions through United Nations sustainable development goals: The internal customer&#x27;s response</td><td>Business Management and Accounting</td><td>Strategy and Management</td><td>identity theory</td><td></td><td>data</td><td></td></tr><tr><td>Pineda-Escobar (2019)</td><td></td><td>Corporate Governance (2)</td><td>Moving the 2030 agenda forward: SDG implementation in Colombia “Think sustainable,</td><td>Business Management and Accounting</td><td>Business Management and Accounting</td><td>United Nations&#x27; sustainable development goals</td><td>Quantitative</td><td>Secondary data</td><td>Al</td></tr><tr><td>Raub and Martin-Rios (2019)</td><td></td><td>International Journal of Contemporary Hospitalty Management (3)</td><td>actlocal&quot;- a stakeholder- filter-modelfor translaing SDGs into sustainability initiatives with local impact</td><td>Business Management and Accounting</td><td>Tourism</td><td>Sustainable innovation and management, stakeholder perspective</td><td>Qualitative (conceptual)</td><td></td><td>All</td></tr><tr><td>Vandenbrande, 2019</td><td>Total Quality</td><td>Management and Business Excellence (2)</td><td>Quality for a sustainable future</td><td>Business Management and Accounting</td><td>Business Management and Accounting</td><td> Quality Management</td><td>Qualitative (conceptual)</td><td></td><td>Al</td></tr></table></body></html>

<html><body><table><tr><td rowspan="2">Authors Year</td><td rowspan="2">Journal (ABS ranking) Journal of Cleaner</td><td rowspan="2">Title</td><td rowspan="2">Academic discipline</td><td rowspan="2">Academic field</td><td rowspan="2">Theoretical framework/ background</td><td rowspan="2">Methodology Qualitative</td><td rowspan="2">(primary/ secondary)</td><td rowspan="2">SDGs mentioned Al</td></tr><tr><td>Strategy and Engineering</td></tr><tr><td>Calabrese et al. (2018)</td><td>Production (2)</td><td>Fostering sustainability-oriented service innovation (SOSI) through business model</td><td>Business Management and Accounting</td><td>Management</td><td>design process</td><td></td><td></td><td></td></tr><tr><td>Goralski and Tan (2020)</td><td>International Journal of Management Education (1)</td><td>renewal: The SOSI tool Artfia intellgence and sustainable development</td><td>Business Management and Accounting</td><td>Strategy and Management</td><td>Business strategy and public policy</td><td> Qualitative</td><td></td><td>Goals: 2, 3, 6, 9, 10, 11, and 14</td></tr><tr><td>Ike et al.(2019)</td><td>Jourmal of Cleaner Production (2)</td><td>The process f seletig and prioritising corporate sustainability issues: Insights for achieving the Sustainable Development Goals</td><td>Business Management and Accounting</td><td>Strategy and Management</td><td>Sustainability development</td><td>Qualitative</td><td></td><td>Al</td></tr><tr><td> Naciti (2019)</td><td>Journal of Cleaner Production (2)</td><td>Corporate governance and board of directors: The effect of a board composition on firm sustainability performance</td><td>Business Management and Accouting</td><td>Strategy and Management</td><td>Stakeholder theory and agency theory</td><td> Quantitative</td><td>Secondary data</td><td>All</td></tr><tr><td>PohIman et al (2019)</td><td>Joural of Cleaner Production (2)</td><td>The role of the focal company in sustainable development goals: A Brazilian food poultry supply chain case study</td><td>Business Management and Accounting</td><td>Strategy and Management</td><td>Sustainable supply chain management</td><td>Qualitative</td><td></td><td>Al</td></tr><tr><td>Sharma and Soederberg (2019)</td><td>Review of International Political Economy (3)</td><td>Redesigning the business of development: the case of the World Economic Forum and global risk management</td><td>Economics, Econometrics and Finance</td><td>Economics and Econometrics</td><td>Global rsk management</td><td>Qualitative (conceptual)</td><td></td><td> Goal: 11,</td></tr><tr><td> Sullivan et al (2018)</td><td>Journal of Cleaner Production (2)</td><td>Using industrial ecology and strategic management concepts to pursue the</td><td>Business Management and Accounting</td><td>Strategy and Management</td><td>Industrial Ecology</td><td> Qualitative</td><td></td><td>7,9,12,and 13</td></tr></table></body></html>

<html><body><table><tr><td colspan="4"></td><td rowspan="2"> Academic</td><td rowspan="2">Theoretical framework/ background</td><td rowspan="2">Methodology</td><td rowspan="2">(primary/ secondary)</td><td rowspan="2">SDGs mentioned</td></tr><tr><td>thors</td><td>Year</td><td>Journal (ABS ranking)</td><td>Academic discipline</td></tr><tr><td>ople et al. (2017)</td><td></td><td>Transnational Corporations (2)</td><td>Title Corporate sustainability assessments: MNE</td><td>Business Management</td><td>field Business Management</td><td>Corporate Sustainability</td><td>Qualitative</td><td></td><td>All</td></tr><tr><td></td><td></td><td></td><td>engagement with sustainable development and the SDGs</td><td> and Accounting</td><td> and Accounting</td><td> Assessment</td><td></td><td></td><td></td></tr></table></body></html>

Second, the industry role in achieving SDGs is another top topic discussed by ABS journals $( 1 0 . 6 4 \% )$ . The topic is dealt by many academic disciplines, first by Business Management and Accounting and then by Economics and Econometrics and Agricultural and Biological Sciences. As for the other main topics discussed on the role of business for SDGs, “Strategy and Management” is the predominant research field. All the papers in the subsample were published in 2-ranked ABS journals in the period 2017–2019. Table 11 (b) shows mining is the most-investigated industry (four out of five papers). The remaining paper focuses on the fishing industry. All the studies adopt a qualitative methodology to investigate the industry role. Whereas Endl, Tost, Hitch, Moser, and Feiel (2019) and Said and Chuenpagdee (2019) use a conceptual approach, Moomen et al. (2019) review prior literature. Monteiro, da Silva, and Moita Neto (2019) and Selmier and Newenham-Kahindi (2017) investigate American and African industry contexts through onsite visits. All these papers do not emphasize specific goals but rather refer to the whole set of SDGs.

# 4.2.4 | Another relevant topic: The relation between CSR and SDGs

Table 12 shows the papers debating the relation between CSR and SDGs $( 8 . 5 1 \%$ ). Grover, Kar, and Ilavarasan (2019) and Poddar, Narula, and Zutshi (2019) analyze the relation quantitatively through the collection of secondary data. Schönherr et al. (2017) and Xia et al. (2018) publish a qualitative investigation of CSR and its interrelationships with the whole set of goals. Most of the papers are in the Business Management discipline (three out of four), and the “Strategy and Management” field is the predominant one among them.

# 4.2.5 | SDGs adoption

SDGs adoption (first-year implementation) is debated by academics too $( 6 . 3 8 \% )$ . Rosati and Faria's (2019a, 2019b) papers on SDGs adoption mainly relate to factors affecting sustainability reporting and adopt a quantitative approach focusing on all the SDGs. TerpstraTong (2017) instead adopts a qualitative approach to develop a framework on the SDG 5 (Gender Equality). All three papers were published in journals related to the Business Management and Accounting discipline, with an emphasis on the on “Strategy and Management” field (Table 13).

<html><body><table><tr><td>Authors</td><td>Year Journal (ABS ranking)</td><td>Title</td><td>Academic discipline</td><td>Academic field</td><td>Theoretical framework/ background</td><td></td><td>Methodology (primary/ secondary)</td><td></td><td>SDGs mentioned</td></tr><tr><td>Horne et al. (2020)</td><td>Journal of Cleaner Production (2)</td><td>Exploring entrepreneurship related to the sustainable development goals - mapping new venture activities with semiautomated content analysis</td><td>Business Management and Accounting</td><td>Strategy and Management</td><td>Sustainable impact measurement and entrepreneurship</td><td>Quantitative</td><td>Secondary data</td><td></td><td>Al</td></tr><tr><td>Mintrom and Thomas (2018)</td><td>International Journal of Entrepreneurial Venturing (1)</td><td></td><td>Policy entrepreneurs and collaborative action: Pursuit of the sustainable development goals</td><td>Business Management and Accounting</td><td>Business and International Management</td><td>Theory of entrepreneurship</td><td> Qualitative</td><td></td><td>All </td></tr><tr><td>Molthan-Hill et al. (2020)</td><td>International Journal of Management Education (1)</td><td>Reducing carbon emissions in business through responsible management microlevels, mesolevels,</td><td>Business education: Influence at the</td><td>Management and Accounting</td><td>Strategy and Management</td><td>Education for Sustainable Development</td><td>Qualitative</td><td></td><td>Goals: 7, 1 and 17</td></tr><tr><td>Nwagwu (2020)</td><td>International Journal of Management Education (1)</td><td>and macrolevels Driving sustainable banking in Nigeria through responsible management education: The case of Lagos Business School</td><td>Business Management and Accounting</td><td> Strategy and</td><td> Management</td><td>United Nations&#x27; sustainable development goals</td><td> Qualitative</td><td></td><td>All</td></tr><tr><td>Schaltegger et al. (2018)</td><td>International Journal of Entrepreneurial Venturing (1)</td><td>Collaborative entrepreneurship for sustainability.Creating solutions in light of the UN Sustainable Development Goals</td><td>Business Management and Accounting</td><td>Business and International Management</td><td>Theory of entrepreneurship</td><td>Qualitative</td><td>(conceptual)</td><td></td><td>All</td></tr><tr><td colspan="2">b. Industry role in achieving SDGs Authors Year Journal Title</td><td colspan="8">Academic Academic Theoretical Methodology</td></tr><tr><td>Endl et al. (2019)</td><td>(ABS ranking) Resources Policy (2)</td><td>Europe&#x27;s mining innovation</td><td>discipline Economic,</td><td>field</td><td>Economics and</td><td>framework/ background Sustainable</td><td>Qualitative</td><td>(primary/ secondary)</td><td>SDGs mentione</td></tr><tr><td></td><td></td><td>trends and their contribution to the sustainable development goals: Blind spots and strong points</td><td>Econometrics and Finance</td><td></td><td>Econometrics</td><td>development</td><td>(conceptual)</td><td></td><td>Al</td></tr></table></body></html>

<html><body><table><tr><td> Authors</td><td>Year</td><td>Journal (ABS ranking)</td><td>Title</td><td>Academic discipline</td><td>Academic field</td><td>Theoretical framework/ background</td><td>Methodology</td><td>(primary/ secondary)</td><td>SDGs mentioned</td></tr><tr><td>Monteiro et al. (2019)</td><td></td><td>Journal of Cleaner Production (2)</td><td>Sustainable Development Goals in mining</td><td>Business Management and Accounting</td><td>Strategy and Management</td><td>United Nations&#x27; sustainable development goals</td><td>Qualitative</td><td></td><td>Al</td></tr><tr><td></td><td> Moomen et al. (2019)</td><td>Journal of Cleaner Production (2)</td><td>Inadequate adaptation of geospatial informationforsustainablemining towards agenda 2030 Sustainable Development Goals</td><td>Business Management and Accounting</td><td>Strategy and Management</td><td>United Nations&#x27; sustainable development goals</td><td> Qualitative</td><td></td><td>Al</td></tr><tr><td>Said and Chuenpagdee (2019)</td><td></td><td>Marine Policy (2)</td><td>Aligning the sustainable development goals to the smallscale fisheries guidelines: A case for EU fisheries governance</td><td>Agricultural and Biological Sciences</td><td>Aquatic Science</td><td>United Nations&#x27; sustainable development goals</td><td>Qualitative (conceptual)</td><td></td><td>Al</td></tr><tr><td>Selmier and Newenham- Kahindi (2017)</td><td></td><td>Transnational Corporations (2)</td><td>Under African skies-Mining TNCs in Africa and the sustainable development goals</td><td>Business Management and Accounting</td><td>Business Management and Accounting</td><td>CSR definition and measurement</td><td> Qualitative</td><td></td><td> All</td></tr></table></body></html>

# 4.2.6 | Capital market and SDGs and SDGs benefits

Other two less widely debated topics are the capital market and SDGs (Table 14, a) and SDGs benefits (Table 14, b). The relationship between the capital market and SDGs is investigated by Cuhna, de Oliveira, Orsato, Klotzle, and Cyrino Oliveira (2019) and by Miralles-Quirós, Miralles-Quirós, and Nogueira (2018). Both papers were published in Business Strategy and the Environment (ABS 3). Further, both adopt a quantitative approach through the collection of secondary data. Whereas Cuhna et al. (2019) mention benefits deriving from all the 17 SDGs, Miralles-Quirós et al. (2018) find benefits from investing in companies focused on Goals 8 (Decent Work and Economic Growth) and 9 (Industry, Innovation and Infrastructure).

The topic of SDGs benefits is dealt with in papers using a qualitative conceptual approach to investigate multinational and international companies. The study by Morioka et al. (2017) belongs to the Business Management Accounting discipline and to the “Strategy and Management” field. Bowie (2019) published in the Journal of Business Ethics (ABS 3), which belongs to the Arts and Humanities area. Both studies refer to all 17 goals.

# 4.2.7 | Residual topics

Finally, Table 15 displays all the papers related to topics discussed just in one paper each. Specifically, Brooker et al.'s (2018) study is about the SDGs' relevance in the fishing industry and focuses on Goal 14 (Life Below Water). Ferro, Padin, Høgevold, Svensson, and Sosa Varela (2019) analyze a business sustainability framework in connection to SDGs. Gunawan, Permatasari, and Tilt (2020) focus on SDG disclosure. Hancock, Ralph, and Ali (2018) check the relation between public-private partnerships and SDGs, and Moldavska and Welo (2019) present research on SDGs performance metrics. As for the other groups of topics, the majority of the studies refer to the Business Management and Accounting discipline and to the “Strategy and Management” field.

# 5 | DISCUSSION AND INSIGHTS FOR FUTURE RESEARCH AGENDA

The current interdisciplinary literature review contributes to answering the call by Kolk et al. (2017) for a coherent approach in studying how corporations may advance sustainable development and extends studies that systematize prior research on sustainable development (Sullivan et al., 2018; Wu et al., 2018; Xia et al., 2018) to SDGs. Our findings reveal the strategic role of businesses as sustainable development agents and highlight the role academia may play in the relation between business and SDGs.

<html><body><table><tr><td colspan="4"> Journal</td><td rowspan="2">Academic Academic discipline field</td><td rowspan="2">Theoretical framework/ background</td><td rowspan="2"> Methodology</td><td rowspan="2">(primary/ secondary)</td><td rowspan="2">SDGs mentioned</td></tr><tr><td>Authors Grover et al. (2019)</td><td>Year (ABS ranking) International Journal</td><td>Title Impact of corporate</td><td>Computer Science, Social Science</td></tr><tr><td></td><td>of Information Management (2)</td><td>social responsibility on reputation-Insights from tweets on Sustainable Development Goals by CEOs</td><td></td><td>Computer Networks and Communications</td><td>CSR and corporate reputation</td><td> Quantitative</td><td>Secondary data</td><td>All</td></tr><tr><td> Poddar et al. (2019)</td><td>Corporate Social Responsibility and Environmental Management (1)</td><td>A study of corporate social responsibility practices of the top Bombay Stock Exchange 500 companies in India and their alignment with the Sustainable Development Goals</td><td>Business Management and Accounting</td><td>Strategy and Management</td><td>CSR definition and measurement</td><td> Quantitative</td><td> Secondary data</td><td>All</td></tr><tr><td>Schönherr et al. (2017)</td><td>Transnational Corporations (2)</td><td>Exploring the interface of CSR and the Sustainable Development Goals</td><td>Business Management and Accounting</td><td>Business Management and Accounting</td><td>Multinational corporations MNCs</td><td>Qualitative (conceptual)</td><td></td><td>All</td></tr><tr><td> Xia et al. (2018)</td><td>Journal of Cleaner Production (2)</td><td>Conceptualising the state of the art of corporate social responsibility (CSR) in the construction industry and its nexus to sustainable development</td><td>Business Management and Accounting</td><td>Strategy and Management</td><td>CSR definition and measurement</td><td> Qualitative</td><td></td><td>All</td></tr></table></body></html>

<html><body><table><tr><td colspan="4">Authors (Year)</td><td colspan="2">Academic discipline</td><td colspan="2">Theoretical framework/background</td><td rowspan="2">(primary/ secondary)</td><td rowspan="2">SDGs mentioned All</td></tr><tr><td>Rosati and Faria</td><td>2019a</td><td>Journal (ABS ranking) Journal of Cleaner Production (2)</td><td>Title Addressing the SDGs in sustainability reports: The relationship with</td><td>Business Management and</td><td>Academic field Strategy and Management</td><td> Sustainability reporting</td><td>Methodology Quantitative</td></tr><tr><td>Rosati and Faria</td><td>2019b</td><td>Corporate Social Responsiblity and Environmental Management (1)</td><td>institutional factors Business contribution to the Sustainable Development Agenda: Organizational factors</td><td>Accounting Business Management and Accounting</td><td>Strategy and Management</td><td> Sustainability reporting</td><td> Quantitative</td><td></td><td>All </td></tr><tr><td>Terpstra-Tong</td><td>2017</td><td>Transnational Corporations (2)</td><td>related to early adoption of SDG reporting MNE subsidiaries&#x27;adoption of gender equality and women empowerment goal: A conceptual</td><td>Business Management and Accounting</td><td>Business Management and Accounting</td><td>Institutional theory</td><td>Qualitative</td><td></td><td>Goal: 5</td></tr></table></body></html>

Th e ro l e of b u si n ess   

<html><body><table><tr><td colspan="9"> a. Capital market and SDGs</td></tr><tr><td> Authors</td><td>Year Journal (ABS ranking)</td><td> Title</td><td>Academic discipline</td><td>Academic field</td><td>Theoretical framework/ background</td><td>Methodology</td><td>(primary/ secondary)</td><td>SDGs mentioned</td></tr><tr><td>Cuhna et al. (2019)</td><td>Business trategy and The Environment (4)</td><td>Can sustainable investments outperform traditional benchmarks? Evidence from globalstock markets</td><td>Business Management and Accounting</td><td>Strategy and Management</td><td>Sustainable investment</td><td>Quantitative</td><td>Secondary data</td><td>Al</td></tr><tr><td>Miralles-Quir6s et al. (2018)</td><td>Business Strategy and The Environment (4)</td><td>Diversification benefits of using exchange-traded funds in compliance to the Sustainable Development</td><td>Business Management and Accounting</td><td>Strategy and Management</td><td>Asset allocation theory</td><td> Quantitative</td><td>Secondary data</td><td>Goals: 8 and 9</td></tr><tr><td colspan="9"> b. SDGs benefits</td></tr><tr><td>Authors Year</td><td>Journal (ABS ranking)</td><td>Title</td><td>Academic discipline</td><td>Academic field</td><td>Theoretical framework/ background</td><td>Methodology</td><td>(primary/ secondary)</td><td>SDGs mentioned</td></tr><tr><td>Bowie (2019)</td><td>Journal of Business Ethics (3)</td><td>International business asa possible civilizing force in a cosmopolitan world</td><td>Arts and Humanities</td><td>Arts and Humanities</td><td>Hirschman classification of capitalism</td><td>Qualitative (conceptual)</td><td></td><td>All</td></tr><tr><td>Morioka et al. (2017)</td><td>Journal of Cleaner Production (2)</td><td>Transforming sustainability challenges into competitive advantage: Multiple case studies kaleidoscope converging into sustainable business models</td><td>Business Management and Accounting</td><td>Strategy and Management</td><td>Sustainable Business Model</td><td> Qualitative</td><td></td><td>All </td></tr></table></body></html>

<html><body><table><tr><td colspan="3"></td><td colspan="2">Academic discipline</td><td colspan="3">Theoretical Methodology(primary/secondary)</td><td rowspan="2">SDGs mentic Goal:</td></tr><tr><td>Authors Year Brooker et al. (2018)</td><td>Journal (ABS ranking) Marine Policy (2)</td><td>Title Scotland as a case study for how benefits of marine</td><td>Agricultural and Biological</td><td>Academic field Aquatic Science</td><td>framework/background Eco- system services</td><td>Qualitative</td><td></td></tr><tr><td>Ferro et al. (2019)</td><td>Journal of Business and Industrial Marketing (2)</td><td>ecosystem services may contribute to the commercial fishing industry Validating and expanding a framework of a triple botom line dominant logic</td><td>Sciences Business Management and Accounting</td><td>Business and International Management</td><td> Triple Bottom Line</td><td> Quantitative</td><td> Secondary data</td><td>All</td></tr><tr><td>Gunawan et al. (2020)</td><td>Journal of Cleaner Production (2)</td><td>for businessustainability through time and across contexts Sustainable Development Goal disclosures: Do they</td><td>Business Management</td><td>Strategy and Management</td><td>Sustainable development</td><td>Quantitative</td><td>Secondary data</td><td>Al</td></tr><tr><td>Hancock et al. (2018)</td><td>Journal of Cleaner Production (2)</td><td>support responsible consumption and production? Bolia&#x27;s lithium frontier: Can public private partnerships</td><td>and Accounting Business Management</td><td>Strategy and Management</td><td>Public-private partnership</td><td> Qualitative</td><td></td><td>All</td></tr><tr><td>Moldavska and Welo (2019)</td><td>Journal of Manufacturing</td><td>deliver a minerals boom for sustainable development? A Holistic approach to corporate sustainability</td><td>and Accounting Computer Science</td><td>Hardware and Architecture</td><td>Corporate Sustainabilty Assessment</td><td>Qualitative</td><td></td><td>Al</td></tr><tr><td></td><td>Systems (1)</td><td>assessment: Incorporating sustainable development goals into sustainable manufacturing performance evaluation</td><td></td><td></td><td></td><td></td><td></td><td></td></tr></table></body></html>

Our results show Europe is the main geographical location (in terms of journals' headquarters, authors' affiliation, and research context) investigated in studies about business and SDGs, independent of academic discipline. This may be due to the fact that the “European Union has set ambitious goals for 2020 to improve the production of renewable energy and energy efficiency, while remaining efforts to reduce the greenhouse gas emission” (Wu et al., 2018, p. 12).

That EU efforts towards environmental sustainability created interest in prior studies in the European context may be supported by the results regarding the specific SDGs mentioned. Environmentrelated business goals such as SDGs 6 (clean water and sanitation), 7 (affordable and clean energy), 12 (responsible consumption and production), and 13 (climate action) are the most frequently mentioned. An investigation of the motivations and the factors affecting the higher interest of Europe in specific SDGs and sustainable development in general (e.g., “The 2030 Agenda for Sustainable Development and SDGs – Environment” by EC., 2019) may provide empirical data points that help researchers better understand the conditions necessary to achieve the 2030 Agenda (e.g., cultural, legislative, type of capitalism, and companies' size). In addition, different contexts (e.g., developing vs. developed countries) and intercontinental studies may provide new perspectives on the topic.

Despite the interest in environmental-related goals, the review shows the main goal of interest is SDG 9, on Industry, Innovation, and Infrastructure. It is followed by SDG 3, on Good Health and WellBeing. The relevance on SDG 9 may be due to different reasons. First, paragraph 67 in the “Means of implementation” section of the 2030 Agenda, which is dedicated to business' role, claims “activities, innovations,7 and investments are deemed essential drivers of sustainable job creation, economic growth, and productivity.” Second, previous studies have already identified that the concept “sustainable” is strongly associated with “innovation” (Sullivan et al., 2018, p. 241).

Overall, our results are in line with the ones by Sullivan et al. (2018), according to which SDGs 7, 9, 12, and 13 have the most relevance, despite the different rank assumed in our study focusing post-SDGs framework. However, a comparison with the practical world suggests some differences. PWC (2019) findings show the top three SDGs mentioned in the companies they reviewed are, in order, SDG 8 (Decent Work and Economic Growth), SDG 13 (Climate Action), and SDG 12 (Responsible Consumption and Production). The comparison between the results of academic and professional studies indicates a low degree of convergence between the two worlds.

Thus, both academic and practical analyses underline the strategic role of companies in environmental sustainability. In other words, they advocate for businesses as sustainable development agents (Haffar $\&$ Searcy, 2018; Wicki & Hansen, 2019) when dealing with environmental aspects. This is supported by the fact that mining, an environmentally sensitive industry, is the main one investigated. The industry is strictly associated with three out of four environmental-related SDGs mentioned—that is, SDGs 7, 12, and 13. Further, prior literature already affirms that many organizations, including mining companies, are more likely to publicly acknowledge the importance of issues beyond their core business, such as poverty alleviation, biodiversity conservation, and sustainable supply chains (Hahn & Kühnen, 2013). Previous research also suggests that harnessing carbon market frameworks is a powerful means to develop new industries and achieve national strategic economic goals (Thomas, Dargusch, & Griffiths, 2011). Overall, these results may extend the role of sustainable development agents to the industry level as well.

Although there is significant academic interest in the environmental debate, then, there are still many gaps in the research on the balance and integration of the business processes with economic and social sustainability in relation to business models and/or specific industries. A future stream of investigation indeed may be one aimed at understanding how companies and specific industries integrate SDGs into their internal processes and value chains, as well as how they consider those goals in relation to their peers or competitors. Such an investigation may be very timely in the post-COVID context, when there is increased need for business reconversion towards more sustainable business models.

Focusing on the subsample of ABS ranked journals, the overall findings highlight the key role played by Business Management and Accounting discipline and in particular by the scholars publishing in the field of “Strategy and Management.” Management literature has a long tradition of innovation, starting with Schumpeter's (1912) theories and moving towards the more recent share value framework developed by Porter and Kramer (2011). The pursuit of innovation as a source of competitive advantage is a major element in the existing strategic management literature (Sullivan et al., 2018, p. 243). There may also be evidence of this in prior studies on the SDG 9 (Industry, Innovation, and Infrastructure), which is the most investigated goal.

Further, our study also shows that very few top journals (all ABS 3) are prone to publish about SDGs. On one hand, top management journals mainly rely on a deductive quantitative approach, starting from an existing theoretical base (Wolceshyn & Daellenback, 2018), but the SDGs topic is practice-based by nature. On the other hand, the review shows the studies predominantly adopt a qualitative methodology. Most of them are conceptual, highlighting the need to develop a theoretical framework for SDGs. This, together with the necessity of big data to collect empirical information on SDGs (Malhotra, Anand, & Singh, 2018), may legitimize our findings. Given that prior studies mostly mention SDGs as a complete set, future research should investigate individual or groups of goals and their interconnections, using different methodologies (quantitative and mixed).

Finally, our study reveals that the main topics discussed by scholars are related to aspects of strategy execution, such as SDG implementation, company and industry roles in achieving SDGs, using entrepreneurship to pursue SDGs, and the relation between CSR and SDGs. Contrary to the study by Sullivan et al. (2018), which indicated that SDG-related studies do not discuss implementation to any great extent (p. 241), we found as that SDG implementation was instead the first topic investigated in studies from 2015 onwards. However, two strategic management and accounting streams are almost absent: one related to SDG performance measurement and the second to SDG disclosure.

A deeper investigation of SDG outcomes and their impact measurement is crucial in the area of performance measurement and management, particularly in relation to macroeconomic system trends. The business development of SDG metrics, performance indicators, tools, and maps may provide companies with new innovation strategies and competitive approaches. In line with van Zanten and van Tulder (2018), we find there is still need for going beyond the selfreported SDG contributions of organizations, analyzing the steps that lead to integration of SDGs into business practices, and thoroughly measuring performance and impact.

Regarding SDG disclosure, Goal 12, Target 12.6, explicitly demands that member states “encourage companies, especially large and transnational companies, to adopt sustainable practices and to integrate sustainability information into their reporting cycle” (UNCTAD, 2020). However, apart from Gunawan et al. (2020), literature on SDG disclosure is almost nonexistent.

The investigation of SDGs disclosures is crucial. Corporate reporting that requires board oversight has been found to change what organizations do and how they think (Adams, 2017). A change in what business does and how business is done is essential to the achievement of the SDGs (Adams, Druckman, and Picot (2020)). In the report of Adams, Druckman, and Picot (2020) on “SDG Disclosure Recommendations,” they identify governance, management approach, performance and targets, and strategy as the four themes of SDG's disclosure that contribute to an alignment with long-term value creation. They offer practical recommendations developed for all types and sizes of reporting organizations, investors, reporting organizations' stakeholders, assurance providers, and national governments. This translates into a call for academia in investigating SDG disclosure in relation to investors' decision-making process and to the capital allocation market, supporting policy-makers and other subjects in understanding the impact of businesses on SDGs and in legislating such a new form of nonfinancial disclosure and its assurance. This work may in turn reveal an expectation gap about companies' blue washing, which represents another area of the disclosure stream with room for future investigation.

# 6 | CONCLUSION

Overall, our review contributes to systematizing a “sparse” literature (Witte & Dyliard, 2017) and shows that the role of business in addressing SDGs has not been specified by prior research. Studies have vertically investigated some aspects (mainly environmental ones), but there is no systemic vision of the kind our paper provides.

Our results underpin a stream of case-based research in which the role of business is that of intercepting macrotrajectories towards sustainable development and adapting them at the microlevel (industry and/or firm level) through individual or sets of SDGs. Transfer of these goals and targets from the international scale that is the UN, to the national scale of individual governments, to the highly varied context that is business is where the difficulty lies (Sullivan et al., 2018, p. 244). In fact, the results we have uncovered about the role of business in tackling SDGs show the predominant influence of the politics and practice but also highlight its limits. Thus, academic intervention into emerging strategies is needed to provide a long-term conceptual vision, which can interact and converge with practice to better orient business in its role as sustainable development agent.

The paper has some limitations related to methodology (e.g., the collection of only English-language articles), which the authors have attempted to mitigate by following the review protocol and discussing together all the papers considered beyond the scope of the current research. Further, the manual content analysis has been done separately by all the authors, and the final data set has been approved after solving some incongruences. Despite the identified limitations, the authors believe the paper may contribute to theory and practice in several ways. The review provides an interdisciplinary and an international overview of the current academic debate on the topic of SDGs, which may be compared to the one occurring in the realm of practice (e.g., PWC, 2019) and indicate what future steps are called for (Adams et al., 2020). Moreover, in highlighting different streams that are currently unexplored, despite being strictly related to strategic business activities and to the sustainable development as a whole, the study provides many starting points for scholars' research agenda. Further development of the current research through narrative or descriptive literature reviews would help to investigate the academic debate on businesses and SDGs more deeply.

# ORCID

Silvia Panfilo $\textcircled{1}$ https://orcid.org/0000-0002-3670-0012

# REFERENCES

Adams, C. (2017). Conceptualising the contemporary corporate value creation process. Accounting, Auditing & Accountability Journal, 30(4), 906–931. https://doi.org/10.1108/AAAJ-04-2016-2529   
Adams, C., Druckman, P. B., & Picot, R. (2020). Sustainable development goals disclosure (SDGD) recommendations. Chartered Accountants ANZ, ICAS, IFAC, IIRC and WBA: ACCA.   
Alvarez Jaramillo, J., Zartha Sossa, J. W., & Orozco Mendoza, G. L. (2019). ! Barriers to sustainability for small and medium enterprises in the framework of sustainable development—Literature review. Business Strategy and the Environment, 28(4), 512–524. http://doi.org/10. 1002/bse.2261   
Avery, G., & Hooper, N. (2017). How David Cooke implemented corporate social responsibility at Konica Minolta Australia. Strategy and Leadership, 45(3), 38–44. http://doi.org/10.1108/SL-04-2017-0034   
Berrone, P., Ricart, J. E., Duch, A. I., Bernardo, V., Salvador, J., Piedra Peña, J., & Rodríguez Planas, M. (2019). EASIER: An evaluation model for public-private partnerships contributing to the sustainable development goals. Sustainability (Switzerland), 11(8), 2339–2364. https:// doi.org/10.3390/su11082339   
Biermann, F., Kanie, N., & Kim, R. E. (2017). Global governance by goal-setting: The novel approach of the UN Sustainable Development Goals. Current Opinion in Environmental Sustainability, 26, 26–31. https://doi. org/10.1016/j.cosust.2017.01.010

Boiral, O., Heras-Saizarbitoria, I., & Brotherton, M. (2019). Corporate sustainability and indigenous community engagement in the extractive industry. Journal of Cleaner Production, 235, 701–711. http://doi.org/ 10.1016/j.jclepro.2019.06.311

Bowie, N. E. (2019). International business as a possible civilizing force in a cosmopolitan world. Journal of Business Ethics, 155(4), 941–950. http://doi.org/10.1007/s10551-017-3670-8   
Brooker, E., Devenport, E., Hopkins, C. R., Hennige, S., Roberts, J. M., & Duncan, C. (2018). Scotland as a case study for how benefits of marine ecosystem services may contribute to the commercial fishing industry. Marine Policy, 93, 271–283. http://doi.org/10.1016/j.marpol.2017. 06.009   
Bulkeley, H., & Newell, P. (2015). Governing climate change (2nd ed.). Routledge: Milton Park, Abingdon, Oxon.   
CABS. (2018). Chartered Association of Business School. Academic Journal Guide. Retrieved from https://charteredabs.org/academic-journalguide-2018/   
Calabrese, A., Forte, G., & Ghiron, N. L. (2018). Fostering sustainabilityoriented service innovation (SOSI) through business model renewal: The SOSI tool. Journal of Cleaner Production, 201, 783–791. http://doi. org/10.1016/j.jclepro.2018.08.102   
Christ, K. L., & Burritt, R. L. (2019). Implementation of sustainable development goals: The role for business academics. Australian Journal of Management, 44(4), 571–593. http://doi.org/10.1177/ 0312896219870575   
Cuhna, F. A. F. D. S., de Oliveira, E. M., Orsato, R. J., Klotzle, M. C., Cyrino Oliveira, F. L., & Caiado, R. G. G. (2019). Can sustainable investments outperform traditional benchmarks? Evidence from global stock markets. Business Strategy and the Environment, 28(7), 1–16. http://doi. org/10.1002/bse.2397   
Delbufalo, E. (2012). Outcomes of inter-organizational trust in supply chain relationships: A systematic literature review and a metaanalysis of the empirical evidence. Supply Chain Management: An International Journal, 17(4), 377–402. https://doi.org/10.1108/ 13598541211246549   
EC. (2019). The 2030 Agenda for Sustainable Development and SDGs—Environment. European Commission. Retrieved 12 November 2019, from https://ec.europa.eu/environment/sustainable-development/SDGs/ index_en.htm   
Endl, A., Tost, M., Hitch, M., Moser, P., & Feiel, S. (2019). Europe's mining innovation trends and their contribution to the sustainable development goals: Blind spots and strong points. Resources Policy, in Press., http://doi.org/10.1016/j.resourpol.2019.101440   
Ferro, C., Padin, C., Høgevold, N., Svensson, G., & Sosa Varela, J. C. (2019). Validating and expanding a framework of a triple bottom line dominant logic for business sustainability through time and across contexts. Journal of Business and Industrial Marketing, 34(1), 95–116. http://doi. org/10.1108/JBIM-07-2017-0181   
Fleming, A., Wise, R. M., Hansen, H., & Sams, L. (2017). The sustainable development goals: A case study. Marine Policy, 86, 94–103. http:// doi.org/10.1016/j.marpol.2017.09.019   
Garcia-Sanchez, I. M., Rodriguez-Ariza, L., Aibar-Guzmàn, B., & AibarGuzmàn, C. (2020). Do institutional investors drive corporate transparency regarding business contribution to the sustainable development goals? Business Strategy and the Environment, 1–18. https://doi.org/10. 1002/bse.2485   
Goralski, M. A., & Tan, T. K. (2020). Artificial intelligence and sustainable development. International Journal of Management Education, 18(1), 1–19. http://doi.org/10.1016/j.ijme.2019.100330   
Gössling, S., & Michael Hall, C. (2019). Sharing versus collaborative economy: How to align ICT developments and the SDGs in tourism? Journal of Sustainable Tourism, 27(1), 74–96. http://doi.org/10.1080/ 09669582.2018.1560455   
Grover, P., Kar, A. K., & Ilavarasan, P. V. (2019). Impact of corporate social responsibility on reputation—Insights from tweets on sustainable development goals by CEOs. International Journal of Information Management, 48, 39–52. http://doi.org/10.1016/j.ijinfomgt.2019.01.009   
Guandalini, I., Sun, W., & Zhou, L. (2019). Assessing the implementation of sustainable development goals through switching cost. Journal of Cleaner Production, 232, 1430–1441. http://doi.org/10.1016/j.jclepro. 2019.06.033   
Gunawan, J., Permatasari, P., & Tilt, C. (2020). Sustainable development goal disclosures: Do they support responsible consumption and production? Journal of Cleaner Production, 246, 2–12. http://doi.org/10. 1016/j.jclepro.2019.118989   
Haffar, M., & Searcy, C. (2018). Target-setting for ecological resilience: Are companies setting environmental sustainability targets in line with planetary thresholds? Business Strategy and the Environment, 27, 1079–1092. http://doi.org/10.1002/bse.2053   
Hahn, R., & Kühnen, M. (2013). Determinants of sustainability reporting: A review of results, trends, theory, and opportunities in an expanding field of research. Journal of Cleaner Production, 59, 5–21. https://doi. org/10.1016/j.jclepro.2013.07.005   
Hajer, M., Nilsson, M., Raworth, K., Bakker, P., Berkhout, F., de Boer, Y., … Kok, M. (2015). Beyond cockpit-ism: Four insights to enhance the transformative potential of the sustainable development goals. Sustainability (Switzerland), 7(2), 1651–1660. http://doi.org/10.3390/ su7021651   
Hák, T., Janoušková, S., & Moldan, B. (2016). Sustainable development goals: A need for relevant indicators. Ecological Indicators, 60, 565–573. https://doi.org/10.1016/j.ecolind.2015.08.003   
Hák, T., Janoušková, S., & Moldan, B. (2018). Global SDGs assessments: Helping or confusing indicators? Sustainability (Switzerland), 10(5), 1–14. https://doi.org/10.3390/su10051540   
Hancock, L., Ralph, N., & Ali, S. H. (2018). Bolivia's lithium frontier: Can public private partnerships deliver a minerals boom for sustainable development? Journal of Cleaner Production, 178, 551–560. http://doi. org/10.1016/j.jclepro.2017.12.264   
Hopwood, B., Mellor, M., & O'Brien, G. (2005). Sustainable development: Mapping different approaches. Sustainable Development, 13(1), 38–52. https://doi.org/10.1002/sd.244   
Horne, J., Recker, M., Michelfelder, I., Jay, J., & Kratzer, J. (2020). Exploring entrepreneurship related to the sustainable development goals— Mapping new venture activities with semi-automated content analysis. Journal of Cleaner Production, 242, 2–11. http://doi.org/10.1016/j. jclepro.2019.118052   
Ike, M., Donovan, J. D., Topple, C., & Masli, E. K. (2019). The process of selecting and prioritising corporate sustainability issues: Insights for achieving the sustainable development goals. Journal of Cleaner Production, 236, 1–13. http://doi.org/10.1016/j.jclepro.2019.117661   
Isaksson, R. (2019). Excellence for sustainability—Maintaining the license to operate. Total Quality Management and Business Excellence, 1–12. http://doi.org/10.1080/14783363.2019.1593044   
Kolk, A., Kourula, A., & Pisani, N. (2017). Multinational enterprises and the sustainable development goals: What do we know and how to proceed? Transnational Corporations, 24(3), 9–32. http://doi.org/10. 18356/6f5fab5e-en   
Lettieri, E., Masella, C., & Radaelli, G. (2009). Disaster management: Findings from a systematic review. Disaster Prevention and Management: An International Journal, 18(2), 117–136. https://doi.org/10.1108/ 09653560910953207   
Littell, J. H., Corcoran, J., & Pillai, V. (2008). Systematic reviews and metaanalysis. USA: Oxford University Press. https://doi.org/10.1093/ acprof:oso/9780195326543.001.0001   
Malhotra, C., Anand, R., & Singh, S. (2018). Applying big data analytics in governance to achieve sustainable development goals (SDGs) in India. In Data Science Landscape (pp. 273–291). Singapore: Springer. https:// doi.org/10.1007/978-981-10-7515-5_19   
Mintrom, M., & Thomas, M. (2018). Policy entrepreneurs and collaborative action: Pursuit of the sustainable development goals. International

Journal of Entrepreneurial Venturing, 10(2), 153–171. http://doi.org/10.

1504/IJEV.2018.092710 Miralles-Quirós, J. L., Miralles-Quirós, M. M., & Nogueira, J. M. (2018). Diversification benefits of using exchange-traded funds in compliance to the sustainable development goals. Business Strategy and the Environment, 28(1), 244–255. http://doi.org/10.1002/bse.2253 Moldavska, A., & Welo, T. (2019). A holistic approach to corporate sustainability assessment: Incorporating sustainable development goals into sustainable manufacturing performance evaluation. Journal of Manufacturing Systems, 50, 53–68. http://doi.org/10.1016/j.jmsy.   
2018.11.004 Molthan-Hill, P., Robinson, Z. P., Hope, A., Dharmasasmita, A., & McManus, E. (2020). Reducing carbon emissions in business through responsible management education: Influence at the micro-, mesoand macro-levels. International Journal of Management Education, 18(1) in press. http://doi.org/10.1016/j.ijme.2019.100328 Monteiro, N. B. R., da Silva, E. A., & Moita Neto, J. M. (2019). Sustainable development goals in mining. Journal of Cleaner Production, 228,   
509–520. http://doi.org/10.1016/j.jclepro.2019.04.332 Moomen, A., Bertolotto, M., Lacroix, P., & Jensen, D. (2019). Inadequate adaptation of geospatial information for sustainable mining towards Agenda 2030 sustainable development goals. Journal of Cleaner Production, 238, 1–8. http://doi.org/10.1016/j.jclepro.2019.117954 Morioka, S. N., Bolis, I., Evans, S., & Carvalho, M. M. (2017). Transforming sustainability challenges into competitive advantage: Multiple case studies kaleidoscope converging into sustainable business models. Journal of Cleaner Production, 167, 723–738. http://doi.org/10.1016/j. jclepro.2017.08.118 Muff, K., Kapalka, A., & Dyllick, T. (2017). The gap frame—Translating the SDGs into relevant national grand challenges for strategic business opportunities. International Journal of Management Education, 15(2),   
363–383. http://doi.org/10.1016/j.ijme.2017.03.004 Muff, K., Kapalka, A., & Dyllick, T. (2018). Moving the world into a safe space—The GAPFRAME methodology. International Journal of Management Education, 16(3), 349–369. http://doi.org/10.1016/j.ijme.2018.   
05.001 Munro, V., & Arli, D. (2019). Corporate sustainable actions through United Nations sustainable development goals: The internal customer's response. International Journal of Nonprofit and Voluntary Sector Marketing, e1660, 1-15. http://doi.org/10.1002/nvsm.1660 Naciti, V. (2019). Corporate governance and board of directors: The effect of a board composition on firm sustainability performance. Journal of Cleaner Production, 237, 1–8. http://doi.org/10.1016/j.jclepro.2019.   
117727 Noci, G., & Verganti, R. (1999). Managing “green” product innovation in small firms. R&D Management, 29(1), 3–15. https://doi.org/10.1111/   
1467-9310.00112 Nwagwu, D. I. (2020). Driving sustainable banking in Nigeria through responsible management education: The case of Lagos business school. International Journal of Management Education, 18(1), 2–9. http://doi.org/10.1016/j.ijme.2019.100332 Orme, M., Cuthbert, Z., Sindico, F., Gibson, J., & Bostic, R. (2015). Good transboundary water governance in the 2015 Sustainable Development Goals: A legal perspective. Water International, 40(7), 969–983. https://doi.org/10.1080/02508060.2015.1099083 Pineda-Escobar, M. A. (2019). Moving the 2030 agenda forward: SDG implementation in Colombia. Corporate Governance (Bingley), 19(1),   
176–188. http://doi.org/10.1108/CG-11-2017-0268 Poddar, A., Narula, S. A., & Zutshi, A. (2019). A study of corporate social responsibility practices of the top Bombay stock exchange 500 companies in India and their alignment with the sustainable development goals. Corporate Social Responsibility and Environmental Management,   
26(6), 1184–1205. http://doi.org/10.1002/csr.1741 Pohlmann, C. R., Scavarda, A. J., Alves, M. B., & Korzenowski, A. L. (2019). The role of the focal company in sustainable development goals: A Brazilian food poultry supply chain case study. Journal of Cleaner Production, 245, 2–13. http://doi.org/10.1016/j.jclepro.2019.118798   
Porter, M. E., & Kramer, M. (2011). Creating shared value. Harvard Business Review, 89(1/2), 62–77.   
PWC. (2019). Creating a strategy for a better world. SDG Challenge 2019. Retrieved 1st January 2020, from https://www.pwc.com/gx/en/ services/sustainability/sustainable-development-goals/sdg-challenge2019.html   
Raub, S. P., & Martin-Rios, C. (2019). “Think sustainable, act local”—A stakeholder-filter-model for translating SDGs into sustainability initiatives with local impact. International Journal of Contemporary Hospitality Management, 31(6), 2428–2447. http://doi.org/10.1108/ IJCHM-06-2018-0453   
Rosati, F., & Faria, L. G. D. $( 2 0 1 9 \mathsf { a }$ . Addressing the SDGs in sustainability reports: The relationship with institutional factors. Journal of Cleaner Production, 215, 1312–1326. http://doi.org/10.1016/j.jclepro.2018. 12.107   
Rosati, F., & Faria, L. G. D. (2019b). Business contribution to the sustainable development agenda: Organizational factors related to early adoption of SDG reporting. Corporate Social Responsibility and Environmental Management, 26(3), 588–597. http://doi.org/10.1002/csr.1705   
Sachs, J. D. (2012). From millennium development goals to sustainable development goals. The Lancet, 379 (9832), 2206–2211. https://doi. org/10.1016/S0140-6736(12)60685-0   
Said, A., & Chuenpagdee, R. (2019). Aligning the sustainable development goals to the small-scale fisheries guidelines: A case for EU fisheries governance. Marine Policy, 107, 1–7. http://doi.org/10.1016/j.marpol. 2019.103599   
Schaltegger, S., Beckmann, M., & Hockerts, K. (2018). Collaborative entrepreneurship for sustainability. creating solutions in light of the UN sustainable development goals. International Journal of Entrepreneurial Venturing, 10(2), 131–152. http://doi.org/10.1504/IJEV.2018. 092709   
Scheyvens, R., Banks, G., & Hughes, E. (2016). The private sector and the SDGs: The need to move beyond “business as usual”. Sustainable Development, 24(6), 371–382. http://doi.org/10.1002/sd.1623   
Schönherr, N., Findler, F., & Martinuzzi, A. (2017). Exploring the interface of CSR and the sustainable development goals. Transnational Corporations, 24(3), 33–47. http://doi.org/10.18356/d3e73f33-en   
Schumpeter, J. A. (1912). Die theorie der wirtschaftlichen entwicklung. Leipzig: Duncker & Humblot.   
Scott, A., & Lucci, P. (2015). Universality and ambition in the post-2015 development agenda: A comparison of global and national targets. Journal of International Development, 27(6), 752–775. https://doi.org/ 10.1002/jid.3118   
SDG Fund. (2019). From MDGs to SDGs. Retrieved 15 November 2019, from https://www.sdgfund.org/mdgs-sdgs   
Selmier, W.T., & Newenham-Kahindi, A. (2017). Under African skiesmining TNCs in Africa and the sustainable development goals. Transnational Corporations, 24(3), 119–133. http://doi.org/10.18356/ d3e73f33-en   
Sharma, S., & Soederberg, S. (2019). Redesigning the business of development: The case of the world economic forum and global risk management. Review of International Political Economy, 2–27. http://doi.org/ 10.1080/09692290.2019.1640125   
Sivarajah, U., Kamal, M. M., Irani, Z., & Weerakkody, V. (2017). Critical analysis of Big Data challenges and analytical methods. Journal of Business Research, 70, 263–286. https://doi.org/10.1016/j.jbusres.2016. 08.001   
Spangenberg, J. H. (2017). Hot air or comprehensive progress? A critical assessment of the SDGs. Sustainable Development, 25(4), 311–321. http://doi.org/10.1002/sd.1657   
Stewart, R., Fantke, P., Bjorn, A., Owsianiak, M., Molin, C., Hauschild, M. Z., & Laurent, A. (2018). Life cycle assessment in corporate sustainability reporting: Global, regional, sectoral, and company-level trends. Business Strategy and the Environment, 27, 1751–1764. http://doi.org/ 10.1002/bse.2241   
Sullivan, K., Thomas, S., & Rosano, M. (2018). Using industrial ecology and strategic management concepts to pursue the sustainable development goals. Journal of Cleaner Production, 174, 237–246. http://doi. org/10.1016/j.jclepro.2017.10.201   
Szennay, A., Szigeti, C., Kovács, N., & Szabó, D. R. (2019). Through the ! blurry looking glass-SDGs in the GRI reports. Resources, 8(2), 1–17. http://doi.org/10.3390/resources8020101   
Terpstra-Tong, J. L. Y. (2017). MNE subsidiaries' adoption of gender equality and women empowerment goal: A conceptual framework. Transnational Corporations, 24(3), 89–102. http://doi.org/10.18356/ d3e73f33-en   
Thomas, S., Dargusch, P., & Griffiths, A. (2011). The drivers and outcomes of the clean development mechanism in China. Environmental Policy and Governance, 21, 223–239. https://doi.org/10.1002/eet.576   
Topple, C., Donovan, J. D., Masli, E. K., & Borgert, T. (2017). Corporate sustainability assessments: MNE engagement with sustainable development and the SDGs. Transnational Corporations, 24(3), 61–71. http://doi.org/10.18356/d3e73f33-en   
Tranfield, D., Denyer, D., & Smart, P. (2003). Towards a methodology for developing evidence-informed management knowledge by means of systematic review. British Journal of Management, 14(3), 207–222. http://doi.org/10.1111/1467-8551.00375   
UN. (2014). The road to dignity by 2030: Ending poverty, transforming all lives and protecting the planet. Synthesis report of the SecretaryGeneral on the post-2015 sustainable development agenda, 69/700. Retrieved 24 November 2019, from https://www.un.org/en/ development/desa/publications/files/2015/01/ SynthesisReportENG.pdf   
UN. (2015). Transforming our world: The 2030 Agenda for Sustainable Development. Resolution adopted by the General Assembly on 25 September 2015 [without reference to a Main Committee (A/70/L.1)] 70/1. Retrieved 12 November 2019, from https://www. un.org/en/development/desa/population/migration/generalassembly/ docs/globalcompact/A_RES_70_1_E.pdf   
UNCTAD. (2020). Sustainable company practice. Retrieved 12 November 2019, from https://stats.unctad.org/Dgff2016/planet/goal12/target_ 12_6.html   
Van Zanten, J. A., & Van Tulder, R. (2018). Multinational enterprises and the sustainable development goals: An institutional approach to corporate engagement. Journal of International Business Policy, 1(3–4), 208–233. https://doi.org/10.1057/s42214-018-0008- $\mathbf { \nabla } \cdot \mathbf { x }$   
Vandenbrande, W. W. (2019). Quality for a sustainable future. Total Quality Management and Business Excellence, 1–9. http://doi.org/10.1080/ 14783363.2019.1588724   
Waage, J., Yap, C., Bell, S., Levy, C., Mace, G., Pegram, T., … Poole, N. (2015). Governing the UN Sustainable Development Goals: Interactions, infrastructures, and institutions. Lancet Global Health, 3(5), 251–252.   
WBCSD. (2017). Better business, better world. World Business Council for Sustainable Development. Retrieved 24 November 2019, from https://www.wbcsd.org/Overview/Resources/General/CEO-Guideto-the-SDGs   
Webster, J. & Watson, R. (2002). Analyzing the past to prepare for the future: Writing a literature review, MIS Quarterly, 26(2) (2002), pp. xiiixxiii. http://doi.org/10.2307/4132319   
Wicki, S., & Hansen, E. (2019). Green technology innovation: Anatomy of exploration processes from a learning perspective. Business Strategy and the Environment, 28, 970–988. http://doi.org/10.1002/bse.2295   
Witte, C., & Dyliard, J. (2017). Guest editors' introduction to the special issue: The contribution of multinational enterprises to the sustainable development goals. Transnational Corporations, 24(3), 1–8. https://doi. org/10.18356/799ae8b0-en   
Woiceshyn, J. and Daellenbach, U (2018). Evaluating inductive versus deductive research in management studies: Implications for authors, editors, and reviewers.   
Wu, J., Guo, S., Huang, H., Liu, W., & Xiang, Y. (2018). Information and communications technologies for sustainable development goals: State-of-the-art, needs and perspectives. IEEE Communications Surveys & Tutorials, 20(3), 2389–2406. http://doi.org/10.1109/COMST.2018. 2812301   
Xia, B., Olanipekun, A., Chen, Q., Xie, L., & Liu, Y. (2018). Conceptualising the state of the art of corporate social responsibility (CSR) in the construction industry and its nexus to sustainable development. Journal of Cleaner Production, 195, 340–353. http://doi.org/10.1016/j.jclepro. 2018.05.157

How to cite this article: Mio C, Panfilo S, Blundo B. Sustainable development goals and the strategic role of business: A systematic literature review. Bus Strat Env. 2020; 1–26. https://doi.org/10.1002/bse.2568